/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialIngredient
extends Ingredient {
    private static final MaterialId WILDCARD = IMaterial.UNKNOWN.getIdentifier();
    private final MaterialVariantId material;
    @Nullable
    private ItemStack[] materialStacks;

    protected MaterialIngredient(Stream<? extends Ingredient.Value> itemLists, MaterialVariantId material) {
        super(itemLists);
        this.material = material;
    }

    public static MaterialIngredient fromItem(IMaterialItem item, MaterialId material) {
        return new MaterialIngredient(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)item))), material);
    }

    public static MaterialIngredient fromItem(IMaterialItem item) {
        return MaterialIngredient.fromItem(item, WILDCARD);
    }

    public static MaterialIngredient fromTag(TagKey<Item> tag, MaterialId material) {
        return new MaterialIngredient(Stream.of(new Ingredient.TagValue(tag)), material);
    }

    public static MaterialIngredient fromTag(TagKey<Item> tag) {
        return MaterialIngredient.fromTag(tag, WILDCARD);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        if (!WILDCARD.equals(this.material) && !this.material.matchesVariant(stack)) {
            return false;
        }
        return super.test(stack);
    }

    public ItemStack[] m_43908_() {
        if (this.materialStacks == null) {
            if (!MaterialRegistry.isFullyLoaded()) {
                return this.getPlainMatchingStacks();
            }
            Stream<Object> items = Arrays.stream(this.getPlainMatchingStacks());
            items = this.material.equals(WILDCARD) ? items.flatMap(stack -> MaterialRegistry.getMaterials().stream().map(mat -> IMaterialItem.withMaterial(stack, mat.getIdentifier())).filter(ItemStack::m_41782_)) : items.map(stack -> IMaterialItem.withMaterial(stack, this.material)).filter(ItemStack::m_41782_);
            this.materialStacks = (ItemStack[])items.distinct().toArray(ItemStack[]::new);
        }
        return this.materialStacks;
    }

    private ItemStack[] getPlainMatchingStacks() {
        return super.m_43908_();
    }

    public JsonElement m_43942_() {
        JsonElement parent = super.m_43942_();
        if (!parent.isJsonObject()) {
            throw new JsonIOException("Cannot serialize an array of material ingredients, use CompoundIngredient instead");
        }
        JsonObject object = parent.getAsJsonObject();
        object.addProperty("type", Serializer.ID.toString());
        if (this.material != WILDCARD) {
            object.addProperty("material", this.material.toString());
        }
        return object;
    }

    protected void invalidate() {
        super.invalidate();
        this.materialStacks = null;
    }

    public boolean isSimple() {
        return this.material == WILDCARD && super.isSimple();
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<MaterialIngredient> {
        public static final ResourceLocation ID = TConstruct.getResource("material");
        public static final Serializer INSTANCE = new Serializer();

        public MaterialIngredient parse(JsonObject json) {
            MaterialId material = json.has("material") ? new MaterialId(GsonHelper.m_13906_((JsonObject)json, (String)"material")) : WILDCARD;
            return new MaterialIngredient(Stream.of(Ingredient.m_43919_((JsonObject)json)), material);
        }

        public MaterialIngredient parse(FriendlyByteBuf buffer) {
            MaterialVariantId material = Objects.requireNonNull(MaterialVariantId.tryParse(buffer.m_130277_()));
            return new MaterialIngredient(Stream.generate(() -> new Ingredient.ItemValue(buffer.m_130267_())).limit(buffer.m_130242_()), material);
        }

        public void write(FriendlyByteBuf buffer, MaterialIngredient ingredient) {
            buffer.m_130070_(ingredient.material.toString());
            ItemStack[] items = ingredient.getPlainMatchingStacks();
            buffer.m_130130_(items.length);
            for (ItemStack stack : items) {
                buffer.m_130055_(stack);
            }
        }

        private Serializer() {
        }
    }
}

